/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.xml;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.io.AtomicFileOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class JaxbXmlWriter<T> {
    private final Schema schema;
    private final JAXBContext jaxbContext;

    @SafeVarargs
    public JaxbXmlWriter(@Nonnull URL schemaUrl, @Nonnull Class<T> typeParameterClass, Class<? extends T> ... typeParameterSubclasses) {
        Preconditions.checkNotNull(typeParameterClass);
        Preconditions.checkNotNull(schemaUrl);
        try {
            this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            this.jaxbContext = typeParameterSubclasses.length == 0 ? JAXBContext.newInstance((Class[])new Class[]{typeParameterClass}) : JAXBContext.newInstance((Class[])typeParameterSubclasses);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Cannot parse XSD schema " + schemaUrl, e);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot initialize JAXB context", e);
        }
    }

    public JaxbXmlWriter(@Nonnull Class<T> typeParameterClass, @Nonnull URL schemeUrl) {
        this(schemeUrl, typeParameterClass, new Class[0]);
    }

    public void write(@Nonnull Path path, @Nonnull T data) throws Exception {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(data);
        try (AtomicFileOutput output = new AtomicFileOutput(path);){
            Marshaller jaxbMarshaller = this.jaxbContext.createMarshaller();
            jaxbMarshaller.setSchema(this.schema);
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.setProperty("com.sun.xml.bind.indentString", (Object)"\t");
            jaxbMarshaller.marshal(data, (OutputStream)output.getOutputStream());
            output.markOk();
        }
        catch (JAXBException e) {
            throw new Exception("Unable to write XML configuration file: " + e, e);
        }
        catch (IOException e) {
            throw new Exception("Cannot create XML configuration file [" + path + "]: " + e, e);
        }
    }
}

